/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.skill.ICooldown;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.IIntervalProvider;
import dev.toma.gunsrpg.util.Interval;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;

public class SecondChanceSkill
extends SimpleSkill
implements ICooldown,
IDescriptionProvider {
    private final DescriptionContainer container;
    private final int maxCooldown;
    private final int healAmount;
    private final Supplier<EffectInstance> effectSupplier;
    private int cooldown;

    public SecondChanceSkill(SkillType<?> type, IIntervalProvider cooldown, int healAmount, int power) {
        super(type);
        this.maxCooldown = cooldown.getTicks();
        this.healAmount = healAmount;
        this.effectSupplier = () -> new EffectInstance(Effects.field_76428_l, Interval.seconds(10).valueIn(Interval.Unit.TICK), power);
        this.container = new DescriptionContainer(type);
        this.container.addProperty("heal", healAmount);
        this.container.addProperty("cooldown", Interval.format(this.maxCooldown, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE, Interval.Unit.SECOND)));
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    @Override
    public boolean canApply(PlayerEntity user) {
        return this.getCooldown() == 0;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setOnCooldown() {
        this.cooldown = this.getMaxCooldown();
    }

    @Override
    public int getMaxCooldown() {
        return this.maxCooldown;
    }

    @Override
    public void onUse(PlayerEntity player) {
        player.func_70606_j((float)this.healAmount);
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.SECOND_CHANCE_USE, SoundCategory.MASTER, 1.0f, 1.0f);
        player.func_195064_c(this.effectSupplier.get());
        PlayerData.get(player).ifPresent(data -> {
            this.cooldown = (int)((double)this.cooldown * data.getAttributes().getAttributeValue(Attribs.SECOND_CHANCE_COOLDOWN));
        });
    }

    @Override
    public CompoundNBT saveData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("cooldown", this.cooldown);
        return nbt;
    }

    @Override
    public void readData(CompoundNBT nbt) {
        this.cooldown = nbt.func_74762_e("cooldown");
    }
}

